/*
cview - Copyright (c) 2002 Teemu Toivola <tst@iki.fi>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 dated June, 1991.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program;  if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <sys/socket.h>
#include <netdb.h>

typedef struct {
	char exp[10];
	char state[20];
	char src1[64];
	char dst1[64];
	char sport1[12];
	char dport1[12];
	char src2[64];
	char dst2[64];
	char sport2[12];
	char dport2[12];

} INFO;

void expire(void);
void parseudp(int debug, int numeric);
void parsetcp(int debug, int numeric);

char procline[512];
INFO i;

int main(int argc, char *argv[]) {

	FILE *ct; /* ct = conntrack */
	int currentarg;
	int debug=0;
	int numeric=0;
	
	for (currentarg=1; currentarg<argc; currentarg++) {
		if (debug)
			printf("arg %d: \"%s\"\n",currentarg,argv[currentarg]);
		if ((strcmp(argv[currentarg],"-h")==0) || (strcmp(argv[currentarg],"--help"))==0) {
		
			printf("cview 1.0 by Teemu Toivola <tst@iki.fi>\n\n");
			printf("\t -h, --help\t help\n");
			printf("\t -n, --numeric\t don't resolve names\n");
			printf("\t -v, --version\t show version\n");
			exit(0);
		} else if ((strcmp(argv[currentarg],"-d")==0) || (strcmp(argv[currentarg],"--debug"))==0) {
			debug=1;
			printf("arg %d: \"%s\"\n",currentarg,argv[currentarg]);
		} else if ((strcmp(argv[currentarg],"-n")==0) || (strcmp(argv[currentarg],"--numeric"))==0) {
			numeric=1;
		} else if ((strcmp(argv[currentarg],"-v")==0) || (strcmp(argv[currentarg],"--version"))==0) {
			printf("cview 1.0 by Teemu Toivola <tst@iki.fi>\n");
			exit(0);
		} else {
			printf("Unknown arg \"%s\".\n",argv[currentarg]);
			printf("Use -h for help.\n");
            exit(1);
		}
	}
		
	if ((ct=fopen("/proc/net/ip_conntrack","r"))==NULL) {
		perror("Error:\nUnable to read /proc/net/ip_conntrack.\n");
		exit(1);
	}

	printf("IP masquerading entries\n");
	printf("prot   expire source                   destination              ports\n");

	while (fgets(procline,512,ct)!=NULL) {
		if (procline[0]=='t') {
			parsetcp(debug, numeric);
		} else if (procline[0]=='u') {
			parseudp(debug, numeric);
		}
	}
	
	fclose(ct);
	
	return 0;

}

void expire(void) {

	int exp_h;
	float exp_min;

	exp_h=atoi(i.exp)/3600;
	exp_min=((float)atoi(i.exp)-((float)exp_h*3600))/60;
	
	if (exp_min>=10.0)
		sprintf(i.exp,"%d:%.2f",exp_h, exp_min);
	else
		sprintf(i.exp,"%d:0%.2f",exp_h, exp_min);
}

void parseudp(int debug, int numeric)
{
	struct hostent *h;
	struct in_addr in;
	
	sscanf(procline+11,"%s %s %s %s %s %s %s %s %s",i.exp, i.src1, i.dst1, i.sport1, i.dport1, i.src2, i.dst2, i.sport2, i.dport2);

	if ((strcmp(i.src1+4,i.dst2+4)!=0) && isdigit(i.src2[5])) {

		if (!numeric) {
			inet_aton(i.src1+4,&in);
		 	h=gethostbyaddr((char*)&in.s_addr,sizeof(in.s_addr), AF_INET);
		}
		if (h && !numeric)
			strncpy(i.src1,h->h_name,64);
		else
			strcpy(i.src1,i.src1+4);

		if (!numeric) {
			inet_aton(i.dst1+4,&in);
		 	h=gethostbyaddr((char*)&in.s_addr,sizeof(in.s_addr), AF_INET);
		}
		if (h && !numeric)
			strncpy(i.dst1,h->h_name,64);
		else
			strcpy(i.dst1,i.dst1+4);
		
		expire();

		printf("udp %9s %-24s %-24s %s -> %s\n",i.exp, i.src1, i.dst1, i.sport1+6, i.dport1+6);

	} else if ((strcmp(i.src2+4,i.dst1+4)!=0) && isdigit(i.src2[5])) {

		if (!numeric) {
			inet_aton(i.src1+4,&in);
		 	h=gethostbyaddr((char*)&in.s_addr,sizeof(in.s_addr), AF_INET);
		}
		if (h && !numeric)
			strncpy(i.src1,h->h_name,64);
		else
			strcpy(i.src1,i.src1+4);

		if (!numeric) {
			inet_aton(i.src2+4,&in);
		 	h=gethostbyaddr((char*)&in.s_addr,sizeof(in.s_addr), AF_INET);
		}
		if (h && !numeric)
			strncpy(i.src2,h->h_name,64);
		else
			strcpy(i.src2,i.dst1+4);

		expire();

		printf("udp %9s %-24s %-24s %s -> %s\n",i.exp, i.src1, i.src2, i.sport1+6, i.sport2+6);
	}


}

void parsetcp(int debug, int numeric)
{
	struct hostent *h;
	struct in_addr in;
	
	sscanf(procline+11,"%s %s %s %s %s %s %s %s %s %s",i.exp, i.state, i.src1, i.dst1, i.sport1, i.dport1, i.src2, i.dst2, i.sport2, i.dport2);

	if ((strcmp(i.src1+4,i.dst2+4)!=0) && isdigit(i.src2[5])) {

		if (!numeric) {
			inet_aton(i.src1+4,&in);
		 	h=gethostbyaddr((char*)&in.s_addr,sizeof(in.s_addr), AF_INET);
		}
		if (h && !numeric)
			strcpy(i.src1,h->h_name);
		else
			strcpy(i.src1,i.src1+4);

		if (!numeric) {
			inet_aton(i.dst1+4,&in);
		 	h=gethostbyaddr((char*)&in.s_addr,sizeof(in.s_addr), AF_INET);
		}
		if (h && !numeric)
			strcpy(i.dst1,h->h_name);
		else
			strcpy(i.dst1,i.dst1+4);
		
		expire();

		printf("tcp %9s %-24s %-24s %s -> %s\n",i.exp, i.src1, i.dst1, i.sport1+6, i.dport1+6);

	} else if ((strcmp(i.src2+4,i.dst1+4)!=0) && isdigit(i.src2[5])) {

		if (!numeric) {
			inet_aton(i.src1+4,&in);
		 	h=gethostbyaddr((char*)&in.s_addr,sizeof(in.s_addr), AF_INET);
		}
		if (h && !numeric)
			strcpy(i.src1,h->h_name);
		else
			strcpy(i.src1,i.src1+4);

		if (!numeric) {
			inet_aton(i.src2+4,&in);
		 	h=gethostbyaddr((char*)&in.s_addr,sizeof(in.s_addr), AF_INET);
		}
		if (h && !numeric)
			strcpy(i.src2,h->h_name);
		else
			strcpy(i.src2,i.dst1+4);

		expire();

		printf("tcp %9s %-24s %-24s %s -> %s\n",i.exp, i.src1, i.src2, i.sport1+6, i.sport2+6);
	}

}
